function gb = importTransm(mainDataFile)
arguments
    mainDataFile string = [];
end

if isempty(mainDataFile)
    [mainDataFileName, path] = uigetfile({'*.xlsx;*.xls',...
        'Excel Spreadsheet (*.xlsx,*.xls)';
        '*.*',  'All Files (*.*)'}, ...
        'Select a File');
    mainDataFile = fullfile(path, mainDataFileName);
end
[~, mainDataFileName] = fileparts(mainDataFile);

% Read main parameters from the "main" sheet
mainData = readcell(mainDataFile);
mainData = cell2table(mainData(2:end, 2:end), 'VariableNames', mainData(1, 2:end), 'RowNames', mainData(2:end, 1));

gb.shortName = mainDataFileName;
gb.fullName = mainData.value{'Full Name'};
gb.mass = mainData.value{'mass'}; % mass, kg

% Read gear data
% Loss evaluation method
lossMethod = mainData.value{'Losses method'};
switch lossMethod
    case "single efficiency"
        gb.lossMethod = "eff";
        opts = detectImportOptions(mainDataFile,'Sheet','map');
        opts.VariableUnitsRange = 'A2:D2';
        gearData = readtable(mainDataFile, opts);

        for n = 1:height(gearData)
            gb.gear(n).spdRatio = gearData.GearRatio(n);
            gb.gear(n).eff = gearData.Efficiency(n);
            gb.gear(n).inertia = gearData.Inertia(n);
        end

    otherwise 
        error("Unsupported losses method """ + lossMethod + """. Supported values are: ""single efficiency"".")
end




end